// author: Filip Roséen <filip.roseen@gmail.com>
// source: http://b.atch.se/posts/constexpr-meta-container

#include "type_list.hpp"
#include "meta_counter.hpp"
#include "meta_list.hpp"

#include <type_traits> // std::is_same

int main () {
  using LX = atch::meta_list<class A>;

  LX::push<void, void, void, void> ();
  LX::set<0, class Hello> ();
  LX::set<2, class World> ();
  LX::pop ();

  LX::value<> x; // type_list<class Hello, void, class World>

  static_assert (
    std::is_same<
      atch::type_list<class Hello, void, class World>, LX::value<>
    >::value, "try again"
  );
}

